# **Visualizing Palestine**

[![Website screenshot][image1]](https://visualizingpalestine.org/)

### **Reviewed by:** Xavier McCormick

### **Review date:** March 5, 2025

### **Site Link**: [https://visualizingpalestine.org/](https://visualizingpalestine.org/) 

### **Archive Links:** 
* [https://archive.ph/oP19m](https://archive.ph/oP19m)   
* [https://archive.ph/wzwyl](https://archive.ph/wzwyl)   
* [https://archive.ph/4wnz9](https://archive.ph/4wnz9)   
* [https://archive.ph/aB6nA](https://archive.ph/aB6nA) 

### **Keywords:** Activism and Advocacy, Data Visualization, Human Rights, Middle East Studies, Digital Memory, Public Humanities, Genocide Studies

### **Data Sources:** 
* Reports from human rights organizations (e.g., UN OCHA, Amnesty International, Human Rights Watch)  
* Statistical data from UN bodies and NGOs  
* Testimonies and oral histories from Palestinian communities  
* News media reports and investigative journalism  
* Archival photographs, maps, and historical documents

### **Processes:** 
* Aggregating diverse datasets into cohesive narratives  
* Designing infographics that distill complex data into accessible, compelling visuals  
* Mapping spatial and temporal dimensions of occupation, displacement, and violence  
* Standardizing data across multiple sources for consistency and clarity  
* Integrating interactive storytelling elements for enhanced user engagement

 

### **Presentation:** 
[Visualizing Palestine](https://visualizingpalestine.org/) is a digital archive and advocacy platform that translates quantitative and qualitative data into visual narratives. The website features an extensive collection of infographics, interactive maps, and multimedia storytelling projects that document Palestinian lived experiences under occupation. The project’s strength lies in its ability to distill this complex geopolitical issue into digestible, emotionally resonant formats that are accessible to a global (English and Arabic literate) audience.

<br>
[Gaza Lives](https://kontinentalist.com/stories/gaza-lives), one of the subprojects of the main site, was developed in collaboration with Kontinentalist and adopts a multimedia storytelling approach, combining data visualizations, personal testimonies, and interactive elements to humanize the realities of life in Gaza. This segment represents an evolution of Visualizing Palestine’s approach by incorporating richer narrative elements and interactive visualizations alongside the project’s signature infographics. 

### **Digital Tools Used:** 
Not all of the digital tools used are listed, but using Wappalyzer and inference, here are some likely tools used:

* **D3.js** – JavaScript library for interactive data visualizations  
* **Svelte** – JavaScript framework used in *Gaza Lives*  
* **WordPress** – Content management system for the main site  
* **Adobe Illustrator** – Used for designing static infographics  
* **Adobe InDesign** – Likely used for layout and publication-ready visuals

### **Languages:** 
* English  
* Arabic

### **Review** 
[Visualizing Palestine](https://visualizingpalestine.org/) was founded in 2012 as a response to the need for data-driven, visually compelling advocacy on Palestinian rights. The project originated from a collective of researchers, designers, and activists seeking to counter mainstream media narratives that often obscure the lived realities of Palestinians. By synthesizing data from human rights organizations, historical records, and on-the-ground testimonies, Visualizing Palestine constructs digital memory artifacts that challenge erasure and misrepresentation.

<br>
The initiative operates independently but partners with scholars, artists, and advocacy groups to ensure that its work is grounded in rigorous research and community engagement. Visualizing Palestine is part of the larger Visualizing Impact ecosystem, a social justice data visualization collective that applies similar methodologies to other human rights issues.

<br>
Visualizing Palestine has three key components. First, the project uses data-driven infographics as its core building blocks. It features [visualizations](https://visualizingpalestine.org/visuals/) on topics such as displacement, blockade, apartheid, settler-colonialism, and resistance. These graphics are widely circulated on social media and in advocacy campaigns. More recent projects, such as Gaza Lives, integrate multimedia and storytelling techniques to create immersive experiences. Finally, the site provides toolkits and fact-based narratives for educators, journalists, and activists.

<br>
The Gaza Lives project exemplifies a shift toward interactive engagement. It interweaves data visualizations with personal stories, using motion graphics, scrolling animations, and audio-visual elements to create a more immersive experience. This approach strengthens the project’s ability to connect with audiences beyond traditional infographics.

<br>
The main criticism I have of the project is that the sources are behind bit.ly links that require access to be given by admins. A more transparent method of sharing those sources through archive links would improve the transparency of the data.

<br>
Visualizing Palestine meets its goal of providing a visually compelling counter-narrative to mainstream media representations of Palestine. By transforming raw data into digestible visual arguments, the project bridges the gap between academia, activism, and public discourse. 

### **How are the collaborative aspects reflected in the project and are there elements that work particularly well?** 
The interdisciplinary team, composed of data analysts, designers, activists, and researchers, ensures that the project maintains both accuracy and compelling visual presentation. By merging expertise from multiple fields, Visualizing Palestine transforms raw data into accessible and persuasive advocacy tools.

<br>
Partnerships with advocacy organizations such as Amnesty International, Al-Haq, and B’Tselem contribute data, analysis, and legal context to the visualizations. These collaborations give credibility to the project and ensure that its materials align with well-documented human rights reports. Additionally, community involvement plays a crucial role in shaping Visualizing Palestine’s narratives. Palestinian voices remain central to the project, reinforcing its commitment to representing lived experiences.

<br>
Beyond its immediate geographic focus, Visualizing Palestine has significant transnational reach. Its infographics and digital storytelling tools are used by activists, educators, and journalists worldwide, extending the project’s impact beyond Palestine. By making complex geopolitical issues more accessible, Visualizing Palestine provides essential educational and advocacy materials for audiences unfamiliar with the historical and contemporary realities of Palestinian life. 

### **Do you see an opportunity for collaboration that would be helpful to the project?** 
The development of interactive archives, particularly by expanding projects like Gaza Lives into a full-fledged digital archive of Palestinian oral histories could be impactful. Integrating GIS mapping with interactive storytelling would allow users to explore historical and contemporary narratives spatially, creating a more immersive and engaging experience.

<br>
Crowdsourced data contributions, where Palestinians could directly submit testimonies, photographs, or localized data could also enhance the project. This would deepen community engagement, allowing for more grassroots contributions and a richer repository of lived experiences.

[image1]: <data:image/png;base64,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>